Rem CornerEffects.vbs
Rem An InDesign VBScript
Rem
Rem Applies corner effects by redrawing the object.
Rem
Rem For more information on InDesign scripting, go to http://www.adobe.com/products/indesign/scripting/index.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count > 0 Then
	    If myInDesign.Selection.Count > 0 Then
	        Set mySelection = myInDesign.Selection
	        ReDim myObjectList(0)
	        For myCounter = 1 To mySelection.Count
	            Select Case TypeName(mySelection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = mySelection.Item(myCounter)
	                Case Else
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        Else
	            MsgBox "Nothing is selected. Please select a rectangle, oval, polygon, text frame, or graphic line and try again."
	        End If
	    Else
	        MsgBox "Nothing is selected. Please select a rectangle, oval, polygon, text frame, or graphic line and try again."
	    End If
	Else
	    MsgBox "Please open a document, select an object, and try again."
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
    myStringList = Array("all points", "first point", "last point", "second point", "third point", "fourth point", "first two", "second and third", "last two", "odd points", "even points")
    Rem Store the current measurement units.
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "CornerEffects"
    With myDialog
        With .DialogColumns.Add
            With .BorderPanels.Add
                With .StaticTexts.Add
                    .StaticLabel = "Corner Type:"
                End With
                Set myCornerEffectButtons = .RadiobuttonGroups.Add
                With myCornerEffectButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Rounded"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Inverse Rounded"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Bevel"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Inset"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Fancy"
                    End With
                End With
            End With
            With .BorderPanels.Add
                With .DialogColumns.Add
                    With .StaticTexts.Add
                        .StaticLabel = "Options:"
                    End With
                End With
                With .DialogColumns.Add
                    With .DialogRows.Add
                        With .DialogColumns.Add
                            With .StaticTexts.Add
                                .StaticLabel = "Offset:"
                                .MinWidth = 60
                            End With
                        End With
                        With .DialogColumns.Add
                            Set myOffsetEditbox = .MeasurementEditboxes.Add
                            With myOffsetEditbox
                                .EditValue = 12
                            End With
                        End With
                    End With
                    With .DialogRows.Add
                        With .DialogColumns.Add
                            With .StaticTexts.Add
                                .StaticLabel = "Pattern:"
                                .MinWidth = 60
                            End With
                        End With
                        With .DialogColumns.Add
                            Set myPatternDropdown = .Dropdowns.Add
                            With myPatternDropdown
                                .StringList = myStringList
                                .SelectedIndex = 0
                            End With
                        End With
                    End With
                End With
            End With
        End With
    End With
    myReturn = myDialog.Show
    If myReturn = True Then
        Rem Get the values from the dialog box.
        myCornerType = myCornerEffectButtons.SelectedButton
        myOffset = myOffsetEditbox.EditValue
        myPattern = myStringList(myPatternDropdown.SelectedIndex)
        myDialog.Destroy
        Rem Iterate through the objects.
        For myCounter = 0 To UBound(myObjectList)
            myChangeCorners myObjectList(myCounter), myCornerType, myOffset, myPattern
        Next
        Rem Reset the measurement units.
        myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
        myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    Else
        myDialog.Destroy
    End If
End Function
Function myChangeCorners(myObject, myCornerType, myOffset, myPattern)
    For myPathCounter = 1 To myObject.Paths.Count
        Set myPath = myObject.Paths.Item(myPathCounter)
        ReDim myPointArray(0)
        For myPathPointCounter = 1 To myPath.PathPoints.Count
            Rem Is the point a qualifying point?
            If myPointTest(myPathPointCounter, myPath, myPattern) = False Then
                myX1 = myPath.PathPoints.Item(myPathPointCounter).LeftDirection(0)
                myY1 = myPath.PathPoints.Item(myPathPointCounter).LeftDirection(1)
                myX2 = myPath.PathPoints.Item(myPathPointCounter).Anchor(0)
                myY2 = myPath.PathPoints.Item(myPathPointCounter).Anchor(1)
                myX3 = myPath.PathPoints.Item(myPathPointCounter).RightDirection(0)
                myY3 = myPath.PathPoints.Item(myPathPointCounter).RightDirection(1)
                myPoint = Array(Array(myX1, myY1), Array(myX2, myY2), Array(myX3, myY3))
                If Not (IsEmpty(myPointArray(0))) Then
                    ReDim Preserve myPointArray(UBound(myPointArray) + 1)
                End If
                myPointArray(UBound(myPointArray)) = myPoint
            Else
                Set myPointA = myPath.PathPoints.Item(myPathPointCounter)
                myAnchor = myPointA.Anchor
                myX1 = myAnchor(0)
                myY1 = myAnchor(1)
                Rem myPointB is the *next* point on the path. If myPathPoint is the last point on the path, then
                Rem myPointB is the first point on the path.
                If myPathPointCounter = (myPath.PathPoints.Count) Then
                    Set myPointB = myPath.PathPoints.Item(1)
                Else
                    Set myPointB = myPath.PathPoints.Item(myPathPointCounter + 1)
                End If
                myAnchor = myPointB.Anchor
                myX2 = myAnchor(0)
                myY2 = myAnchor(1)
                Rem myPointC is the *previous* point on the path. If myPathPoint is the first point on the path,
                Rem then myPointC is the last point on the path.
                If myPathPointCounter = 1 Then
                    Set myPointC = myPath.PathPoints.Item(myPath.PathPoints.Count)
                Else
                    Set myPointC = myPath.PathPoints.Item(myPathPointCounter - 1)
                End If
                myAnchor = myPointC.Anchor
                myX3 = myAnchor(0)
                myY3 = myAnchor(1)
                myPoints = myAddPoints(myX1, myY1, myX2, myY2, myX3, myY3, myOffset)
                myNewX1 = myPoints(0)
                myNewY1 = myPoints(1)
                myNewX2 = myPoints(2)
                myNewY2 = myPoints(3)
                Rem Calculate new path point values based on the path effect type.
                Rem We won't add the points to the path one at a time instead, we'll
                Rem create an array that holds all of the point locations and curve
                Rem handle positions, and we will then
                Select Case myCornerType
                    Case 0
                        Rem Rounded corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myX1, myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 1:
                        Rem Inverse Rounded corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 2:
                        Rem Bevel corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 3:
                        Rem Inset corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 4:
                        Rem Fancy corner effect.
                        myOneThird = 0.33333333332
                        myTwoThirds = 0.666666666667
                        myPointZX = myNewX2 + myNewX1 - myX1
                        myPointZY = myNewY2 + myNewY1 - myY1
                        myTemp1X = (myX1 - myNewX2) * myTwoThirds
                        myTemp1Y = (myY1 - myNewY2) * myTwoThirds
                        myTemp2X = (myX1 - myNewX1) * myTwoThirds
                        myTemp2Y = (myY1 - myNewY1) * myTwoThirds
                        myPointDX = myPointZX + myOneThird * (myNewX1 - myPointZX)
                        myPointDY = myPointZY + myOneThird * (myNewY1 - myPointZY)
                        myPointEX = myPointZX + myOneThird * (myNewX2 - myPointZX)
                        myPointEY = myPointZY + myOneThird * (myNewY2 - myPointZY)
                        myPointFX = myPointDX + myTwoThirds * (myX1 - myTemp1X - myPointDX)
                        myPointFY = myPointDY + myTwoThirds * (myY1 - myTemp1Y - myPointDY)
                        myPointGX = myPointEX + myTwoThirds * (myX1 - myTemp2X - myPointEX)
                        myPointGY = myPointEY + myTwoThirds * (myY1 - myTemp2Y - myPointEY)
                        myPointHX = myPointZX + myTemp1X + myTemp2X
                        myPointHY = myPointZY + myTemp1Y + myTemp2Y
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointEX, myPointEY), Array(myPointEX, myPointEY), Array(myPointEX, myPointEY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointGX, myPointGY), Array(myPointGX, myPointGY), Array(myPointGX, myPointGY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointHX, myPointHY), Array(myPointHX, myPointHY), Array(myPointHX, myPointHY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointFX, myPointFY), Array(myPointFX, myPointFY), Array(myPointFX, myPointFY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointDX, myPointDY), Array(myPointDX, myPointDY), Array(myPointDX, myPointDY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                End Select
            End If
        Next
        myPath.EntirePath = myPointArray
    Next
End Function
Function myAddPoints(myX1, myY1, myX2, myY2, myX3, myY3, myOffset)
    myHypotenuse = Sqr(((myX1 - myX2) ^ 2) + ((myY1 - myY2) ^ 2))
    If myY1 <> myY2 Then
        myXAdjust = ((myX1 - myX2) / myHypotenuse) * myOffset
        myYAdjust = ((myY1 - myY2) / myHypotenuse) * myOffset
        myNewX1 = myX1 - myXAdjust
        myNewY1 = myY1 - myYAdjust
    Else
        myXAdjust = myOffset
        myYAdjust = 0
        If myX1 < myX2 Then
            myNewX1 = myX1 + myXAdjust
            myNewY1 = myY1 + myYAdjust
        Else
            myNewX1 = myX1 - myXAdjust
            myNewY1 = myY1 - myYAdjust
        End If
    End If
    myHypotenuse = Sqr(((myX1 - myX3) ^ 2) + ((myY1 - myY3) ^ 2))
    If myY1 <> myY3 Then
        myXAdjust = ((myX1 - myX3) / myHypotenuse) * myOffset
        myYAdjust = ((myY1 - myY3) / myHypotenuse) * myOffset
        myNewX2 = myX1 - myXAdjust
        myNewY2 = myY1 - myYAdjust
    Else
        myXAdjust = myOffset
        myYAdjust = 0
        If myX1 < myX3 Then
            myNewX2 = myX1 + myXAdjust
            myNewY2 = myY1 + myYAdjust
        Else
            myNewX2 = myX1 - myXAdjust
            myNewY2 = myY1 - myYAdjust
        End If
    End If
    myAddPoints = Array(myNewX1, myNewY1, myNewX2, myNewY2)
End Function
Function myPointTest(myPathPointCounter, myPath, myPattern)
    Rem Do not apply the corner effect to the first or last point in an open path
    Rem (this is the way that InDesign's corner effects work).
    If ((myPath.PathType = idPathType.idOpenPath) And ((myPathPointCounter = 0) Or (myPathPointCounter = myPath.PathPoints.Count))) Then
        myPointTest = False
        Exit Function
    Else
        Select Case myPattern
            Case "all points"
                myPointTest = True
                Exit Function
            Case "first point":
                If myPathPointCounter = 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "last point":
                If myPathPointCounter = myPath.PathPoints.Count Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "second point":
                If myPathPointCounter = 2 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "third point":
                If myPathPointCounter = 3 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "fourth point":
                If myPathPointCounter = 4 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "first two":
                If ((myPathPointCounter = 1) Or (myPathPointCounter = 2)) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "second and third":
                If ((myPathPointCounter = 2) Or (myPathPointCounter = 3)) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "last two":
                If ((myPathPointCounter = myPath.PathPoints.Count) Or (myPathPointCounter = (myPath.PathPoints.Count - 1))) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "even points":
                If myPathPointCounter Mod 2 = 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "odd points":
                If myPathPointCounter Mod 2 <> 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
        End Select
    End If
End Function
Function myAddToArray(myArray, myItem)
    If Not (IsEmpty(myArray(0))) Then
        ReDim Preserve myArray(UBound(myArray) + 1)
    End If
    If Not (IsObject(myItem)) Then
        myArray(UBound(myArray)) = myItem
    Else
        Set myArray(UBound(myArray)) = myItem
    End If
End Function
'' SIG '' Begin signature block
'' SIG '' MIIhPQYJKoZIhvcNAQcCoIIhLjCCISoCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' aobv8CKDScIBjczo0HZyNRyUAsD+noiKe+sikYwhgwKg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAEwghP9AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIC2ERHDFnOOx
'' SIG '' aawjM3bvPvD4lCG8IsYXa8OICXtfwxaEMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAjkUO68LN
'' SIG '' 542BAYd1TO20ft2VRt4pD5OeOo+GW+j4ZqBV4OcW1z9o
'' SIG '' uRy5qZSL0obAufwoTEUq9cxuCj8IggtDISbYW33xXUpw
'' SIG '' rSpvzWcaKLGbnyJvuc878j6DYMKmfwSkwdNtPQ8W5q2i
'' SIG '' DICG0fA6IfytoCe33QA5ECJwyePiXgP7jnQT2ULem5IZ
'' SIG '' 7WbHu94ynJ4B6SReLtOPsQhvcLD8QGGcNh8E/9grSqmb
'' SIG '' r4LQoqfWZfZ/+uEA2fECu3acDrxKbDhcskNp8aqzUlPh
'' SIG '' ConZ5zf0I2vBeGT9jflE9Lzo0GtoPRvkli0sfoQrCRIE
'' SIG '' pOaaJ/tXGy6ZbwNHRM0bcJxUjKGCEbIwghGuBgorBgEE
'' SIG '' AYI3AwMBMYIRnjCCEZoGCSqGSIb3DQEHAqCCEYswghGH
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCCwpc/zyN63wR9LHJxJmcxP+UW8Q/69Pbpm
'' SIG '' hY/g2puDFgIQdj4h4ySKNTWlyomotDeL8xgPMjAyMjA0
'' SIG '' MTgxOTAyMjNaoIINfDCCBsYwggSuoAMCAQICEAp6Soie
'' SIG '' yZlCkAZjOE2Gl50wDQYJKoZIhvcNAQELBQAwYzELMAkG
'' SIG '' A1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
'' SIG '' MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJT
'' SIG '' QTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
'' SIG '' MjAzMjkwMDAwMDBaFw0zMzAzMTQyMzU5NTlaMEwxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjEkMCIGA1UEAxMbRGlnaUNlcnQgVGltZXN0YW1wIDIw
'' SIG '' MjIgLSAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC
'' SIG '' CgKCAgEAuSqWI6ZcvF/WSfAVghj0M+7MXGzj4CUu0jHk
'' SIG '' PECu+6vE43hdflw26vUljUOjges4Y/k8iGnePNIwUQ0x
'' SIG '' B7pGbumjS0joiUF/DbLW+YTxmD4LvwqEEnFsoWImAdPO
'' SIG '' w2z9rDt+3Cocqb0wxhbY2rzrsvGD0Z/NCcW5QWpFQiNB
'' SIG '' Wvhg02UsPn5evZan8Pyx9PQoz0J5HzvHkwdoaOVENFJf
'' SIG '' D1De1FksRHTAMkcZW+KYLo/Qyj//xmfPPJOVToTpdhiY
'' SIG '' mREUxSsMoDPbTSSF6IKU4S8D7n+FAsmG4dUYFLcERfPg
'' SIG '' OL2ivXpxmOwV5/0u7NKbAIqsHY07gGj+0FmYJs7g7a5/
'' SIG '' KC7CnuALS8gI0TK7g/ojPNn/0oy790Mj3+fDWgVifnAs
'' SIG '' 5SuyPWPqyK6BIGtDich+X7Aa3Rm9n3RBCq+5jgnTdKEv
'' SIG '' sFR2wZBPlOyGYf/bES+SAzDOMLeLD11Es0MdI1DNkdcv
'' SIG '' nfv8zbHBp8QOxO9APhk6AtQxqWmgSfl14ZvoaORqDI/r
'' SIG '' 5LEhe4ZnWH5/H+gr5BSyFtaBocraMJBr7m91wLA2JrII
'' SIG '' O/+9vn9sExjfxm2keUmti39hhwVo99Rw40KV6J67m0uy
'' SIG '' 4rZBPeevpxooya1hsKBBGBlO7UebYZXtPgthWuo+epiS
'' SIG '' Uc0/yUTngIspQnL3ebLdhOon7v59emsCAwEAAaOCAYsw
'' SIG '' ggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAA
'' SIG '' MBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1UdIAQZ
'' SIG '' MBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNVHSME
'' SIG '' GDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNVHQ4E
'' SIG '' FgQUjWS3iSH+VlhEhGGn6m8cNo/drw0wWgYDVR0fBFMw
'' SIG '' UTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRp
'' SIG '' bWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEEgYMw
'' SIG '' gYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0
'' SIG '' UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNydDAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAgEADS0jdKbR9fjqS5k/AeT2
'' SIG '' DOSvFp3Zs4yXgimcQ28BLas4tXARv4QZiz9d5YZPvpM6
'' SIG '' 3io5WjlO2IRZpbwbmKrobO/RSGkZOFvPiTkdcHDZTt8j
'' SIG '' ImzV3/ZZy6HC6kx2yqHcoSuWuJtVqRprfdH1AglPgtal
'' SIG '' c4jEmIDf7kmVt7PMxafuDuHvHjiKn+8RyTFKWLbfOHzL
'' SIG '' +lz35FO/bgp8ftfemNUpZYkPopzAZfQBImXH6l50pls1
'' SIG '' klB89Bemh2RPPkaJFmMga8vye9A140pwSKm25x1gvQQi
'' SIG '' FSVwBnKpRDtpRxHT7unHoD5PELkwNuTzqmkJqIt+ZKJl
'' SIG '' lBH7bjLx9bs4rc3AkxHVMnhKSzcqTPNc3LaFwLtwMFV4
'' SIG '' 1pj+VG1/calIGnjdRncuG3rAM4r4SiiMEqhzzy350yPy
'' SIG '' nhngDZQooOvbGlGglYKOKGukzp123qlzqkhqWUOuX+r4
'' SIG '' DwZCnd8GaJb+KqB0W2Nm3mssuHiqTXBt8CzxBxV+NbTm
'' SIG '' tQyimaXXFWs1DoXW4CzM4AwkuHxSCx6ZfO/IyMWMWGmv
'' SIG '' qz3hz8x9Fa4Uv4px38qXsdhH6hyF4EVOEhwUKVjMb9N/
'' SIG '' y77BDkpvIJyu2XMyWQjnLZKhGhH+MpimXSuX4IvTnMxt
'' SIG '' tQ2uR2M4RxdbbxPaahBuH0m3RFu0CAqHWlkEdhGhp3cC
'' SIG '' ExwwggauMIIElqADAgECAhAHNje3JFR82Ees/ShmKl5b
'' SIG '' MA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVTMRUw
'' SIG '' EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
'' SIG '' dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0
'' SIG '' IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAwMDBa
'' SIG '' Fw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVTMRcw
'' SIG '' FQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMy
'' SIG '' RGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1
'' SIG '' NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3DQEB
'' SIG '' AQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE
'' SIG '' 8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI82j6
'' SIG '' ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR8XOx
'' SIG '' s+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt
'' SIG '' 69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3HxqV3rw
'' SIG '' N3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtArF+y
'' SIG '' 3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLF
'' SIG '' uk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu9Yem
'' SIG '' j052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz9vae
'' SIG '' 5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0
'' SIG '' QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/w
'' SIG '' ojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/BZxm
'' SIG '' SVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T/jnA
'' SIG '' +bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjB
'' SIG '' Jgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11GdeJg
'' SIG '' o1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzSM7TN
'' SIG '' sQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIB
'' SIG '' ADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+eyG8w
'' SIG '' HwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUF
'' SIG '' BwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYY
'' SIG '' aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUF
'' SIG '' BzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20v
'' SIG '' RGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8E
'' SIG '' PDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJ
'' SIG '' KoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m1tgh
'' SIG '' QuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxpwc8d
'' SIG '' B+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiC
'' SIG '' qBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqrhc1D
'' SIG '' X+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp876i8
'' SIG '' dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6Z
'' SIG '' JxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY+/um
'' SIG '' nXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHxcpzp
'' SIG '' SwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNB
'' SIG '' zU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhzq6YB
'' SIG '' T70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o08f5
'' SIG '' 6PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZ
'' SIG '' ynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3
'' SIG '' OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ8ADN
'' SIG '' XcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2
'' SIG '' VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8
'' SIG '' MYIDdjCCA3ICAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUG
'' SIG '' A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYg
'' SIG '' VGltZVN0YW1waW5nIENBAhAKekqInsmZQpAGYzhNhped
'' SIG '' MA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqGSIb3DQEJAzEN
'' SIG '' BgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjIw
'' SIG '' NDE4MTkwMjIzWjArBgsqhkiG9w0BCRACDDEcMBowGDAW
'' SIG '' BBSFCPOGUVyz0wd9trS3wH8bSl5B3jAvBgkqhkiG9w0B
'' SIG '' CQQxIgQgeEfQ/fmdotMKa2Duw2gjvXYmzApgEx50BtKP
'' SIG '' 6sDPrkUwNwYLKoZIhvcNAQkQAi8xKDAmMCQwIgQgnaaQ
'' SIG '' FcNJxsGJeEW6NYKtcMiPpCk722q+nCvSU5J55jswDQYJ
'' SIG '' KoZIhvcNAQEBBQAEggIAGqoo0dVlAx9gpOXfdkKV8m+Z
'' SIG '' D54R0RV0oQ0dfQBlfo9Av8ZAynBycSMzfkBkBp4XBP2E
'' SIG '' MBf2eItppgVnkkuzvpqhrtSbjImzkm81bJv5GbFpx8ht
'' SIG '' fSF1q6w2jrlCaYnJUOTmcw+CRNUwtcS/fHxLag8VZDCc
'' SIG '' 7a37izCN8FonqtqJFL/oquN6Ci+ui1NpYWXcwF4urzNt
'' SIG '' yiCJruD10QOACraQ6tsAq89UPAwPu6SHg+t5PbPhP8KL
'' SIG '' qLnkoUfJf5jrqfk9xTRyvd+kQm3cZHsOauDdgEXw+Uak
'' SIG '' oXjQZ6ZoVNPuy3TwJS2Un0oK8IwKFibKC9MS3KMq1hIz
'' SIG '' Xws9OPzi+mE8yUkjHDlu6ZDo2IUA4+oGMKngtsEpBdAf
'' SIG '' hdYUGQxjc+Q/K/+RtEebsXEKzXpD+hmQWx+ivWiMF9RW
'' SIG '' j99ErAfkiXQU6mRu9wZ2hi+t2Knfogu0VbYJFZ1CEJLz
'' SIG '' dy8QV992f4xgEPS5Ygf1/D2XvDu/ujgSZhnHtAlXADdc
'' SIG '' cU1YrLOKXmVddYyTY9RWRoMUPbiNDlOvo1xjo+HlN9d6
'' SIG '' 3t7ZpllWc+9ZFQhMrfmuK9niGK+hnLZ8m9nTjTOh76tU
'' SIG '' e5W6YCMNbe2MuTlz47l9/SC0D1Fm21ArrRJI4b4w+mEN
'' SIG '' yLYKGJMrhHv3jCzq7fZwxL0uRBd+/L7IncT+dRLiNq4=
'' SIG '' End signature block
